cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

global type tmax
global adj_series "Without CRN"
global distance 100


*Run at least once to produce smaller versions of the files to reduce load times for each type
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw.$type.dta", clear
keep if year >= 2000
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", replace

use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN $adj_series FLs.52j.$type.dta", clear
keep if year >= 2000
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", replace


use crn_hcn_station_pairs_$distance.dta, clear

su station_pair_id
local max = r(max)

clear
tempfile results
cap gen date = 0
keep if _n < 0
sort date
save "`results'", replace

forvalues pair_id = 1(1)`max' {
	quietly {
	use crn_hcn_station_pairs_$distance.dta, clear
	keep if station_pair_id == `pair_id'
	local hcn_station_id = station_id_hcn[1]
	local crn_station_id = station_id_crn[1]
	local distance = distance[1]
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `hcn_station_id'
	rename avg hcn_adj_$type
	keep hcn_adj_$type date
	drop if hcn_adj_$type == . | hcn_adj_$type == -9999
	sort date
	tempfile hcn_adj_results
	save "`hcn_adj_results'", replace
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
	keep if station_id == `crn_station_id'
	rename $type crn_$type
	gen date = ym(year, month)
	keep crn_$type date
	drop if crn_$type == . | crn_$type == -9999
	sort date
	merge date using "`hcn_adj_results'"
	keep if _merge == 3
	drop _merge
	sort date	
	
	gen month = month(dofm(date))
	gen year = year(dofm(date))

	sort month	
	tempfile tempdata
	save "`tempdata'", replace

	collapse (mean) base_crn=crn_$type base_hcn_adj=hcn_adj_$type, by(month)
	sort month

	merge month using "`tempdata'"
	drop _merge
	replace crn_$type = crn_$type - base_crn
	replace hcn_adj_$type = hcn_adj_$type - base_hcn_adj
	drop base_crn base_hcn_adj
	
	gen diff = crn_$type - hcn_adj_$type
	gen crn_id = `crn_station_id'
	gen hcn_id = `hcn_station_id'
	sort date
	keep date diff crn_id hcn_id
	append using "`results'"
	save "`results'", replace
	
	}
}

use "`results'", clear

sort date crn_id
save "difference_series $type $distance.dta", replace


use "difference_series $type $distance.dta", clear
collapse (count) count=diff, by(crn_id date)
gen weight = 1 / count
drop count
sort date crn_id
merge date crn_id using "difference_series $type $distance.dta"
drop _merge

keep if year(dofm(date)) >= 2004

collapse (mean) mean=diff (sd) sd=diff [iweight=weight], by(date)


format date %tm

gen high = mean + sd * 2
gen low = mean - sd * 2

lowess  mean date, bwidth(0.2) gen(lowess_fit) nograph

#delimit ;
	twoway 
	(line mean date, lcolor(black) lwidth(medium))
	(line lowess_fit date, lcolor(red) lwidth(medsmall))
	,
	title("TMax CRN/HCN Adj Pair Differences", size(medium))
	ytitle("Degrees C", size(medsmall))
  	xlabel(528 "2004" 552 "2006" 576 "2008" 600 "2010" 624 "2012" 648 "2014",labsize(medium))
	ylabel(-0.3(0.1)0.3, gmax glcolor(black) glpattern(dot) labsize(medium)) 
	graphregion(color(white) lcolor(ebg))
	legend(region(fcolor(gs15) lcolor(ebg)) size(small)  label(1 "Mean Pair Differences")  label(2 "Lowess Fit") order(1 2) col(2))
	;
#delimit cr

graph export "Mean Pair Differences $type $distance.png", replace width(1000)
